<?php

/**
 * This is the model class for table "ParametryGry".
 *
 * The followings are the available columns in table 'ParametryGry':
 * @property double $id
 * @property string $nazwa
 * @property string $wartosc
 */
class ParametryGry extends CActiveRecord
{
	static private $_parameters = array();

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ParametryGry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ParametryGry';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('nazwa', 'length', 'max'=>64),
			array('wartosc', 'length', 'max'=>4000),
			array('opis', 'length', 'max'=>2000),

			array('id, nazwa, wartosc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('ParametryGry', 'ID'),
			'nazwa'=>Yii::t('ParametryGry', 'Nazwa'),
			'wartosc'=>Yii::t('ParametryGry', 'Wartość'),
			'opis'=>Yii::t('ParametryGry', 'Opis'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"t"."id"', $this->id);
		$criteria->compare('LOWER("t"."nazwa")', strtolower($this->nazwa), true);
		$criteria->compare('LOWER("t"."wartosc")', strtolower($this->wartosc), true);
		$criteria->compare('LOWER("t"."opis")', strtolower($this->opis), true);

		$criteria->addCondition('"t"."nazwa" NOT IN (\'CZY_TRYB_DEMO\', \'ILOSC_AKTYWNYCH_LEKCJI\')');

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function save($runValidation = true, $attributes = null)
	{
		self::$_parameters = array();

		return parent::save($runValidation, $attributes);
	}

	public function getLaborOfficeActivityType()
	{
		$sql = 'SELECT *
				FROM "ParametryGry"
				WHERE "nazwa" LIKE \'URZAD_PRACY_RODZAJ_DZIALALNOSCI_%\'';

		$result = Yii::app()->db->createCommand($sql)->queryAll();
		$resultArray = array();

		$counter = 1;
		foreach($result as $row)
		{
			$resultArray[$counter] = $row['wartosc'];
			$counter++;
		}
		return $resultArray;
	}

	public static function getValue($key, $default = null)
	{
		if(count(self::$_parameters) == 0)
			self::$_parameters = CHtml::listData(self::model()->findAll(), 'nazwa', 'wartosc');

		return isset(self::$_parameters[$key]) && !is_null(self::$_parameters[$key]) ? self::$_parameters[$key] : $default;
	}

	public static function getFloat($key, $default = null)
	{
		return (float)self::getValue($key, $default);
	}

	public static function getInt($key, $default = null)
	{
		return (int)self::getValue($key, $default);
	}
}
